<?php $__env->startSection('head'); ?>

    <!-- BEGIN PAGE LEVEL STYLES -->
    <?php echo HTML::style("assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.css"); ?>

    <?php echo HTML::style("assets/global/plugins/bootstrap-select/bootstrap-select.min.css"); ?>

    <?php echo HTML::style("assets/global/plugins/select2/select2.css"); ?>

    <?php echo HTML::style("assets/global/plugins/jquery-multi-select/css/multi-select.css"); ?>


    <!-- BEGIN THEME STYLES -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('mainarea'); ?>


    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        <?php echo e($pageTitle); ?>

    </h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="<?php echo e(route('admin.dashboard.index')); ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="<?php echo e(route('admin.settings.edit','setting')); ?>">Settings</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href=""> Setting</a>
            </li>
        </ul>

    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->

            <div id="load">

                
                <?php echo $__env->make('admin.common.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                


            </div>
            <div class="portlet box blue">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-cogs"></i>Edit <?php echo e($pageTitle); ?>

                    </div>
                    <div class="tools">
                    </div>
                </div>

                <div class="portlet-body form">

                    <!------------------------ BEGIN FORM---------------------->
                    <?php echo Form::model($setting, ['method' => 'PUT','files' => true,'class'=>'form-horizontal form-bordered' , 'id' => 'edit_setting_form']); ?>


                    <div class="form-body">

                        <div class="form-group">
                            <label class="control-label col-md-2">Website Logo</label>
                            <div class="col-md-6">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">

                                        <img src="<?php echo e($setting->getLogoImageAttribute()); ?>" height="30px" width="117px"/>

                                    </div>
                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                         style="max-width: 200px; max-height: 150px;">
                                    </div>
                                    <div>
                                                       <span class="btn default btn-file">
                                                       <span class="fileinput-new">
                                                       Change image </span>
                                                       <span class="fileinput-exists">
                                                       Change </span>
                                                       <input type="file" name="logo">
                                                       </span>
                                        <a href="#" class="btn btn-sm red fileinput-exists" data-dismiss="fileinput">
                                            Remove </a>
                                    </div>
                                </div>
                                <div class="clearfix margin-top-10">
                                                        <span class="label label-danger">
                                                        NOTE! </span> Image Size must be 117px x 30px

                                </div>

                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label">Website: <span class="required">
                                        * </span>
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="website" placeholder="Website Title"
                                       value="<?php echo e($setting->website); ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label">Email: <span class="required">
                                            * </span>
                            </label>
                            <div class="col-md-6">
                                <input type="text" class="form-control" name="email" placeholder="Email"
                                       value="<?php echo e($setting->email); ?>">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-2 control-label">Name: <span class="required">  * </span></label>

                            <div class="col-md-6">
                                <input type="text" class="form-control" name="name" placeholder="Name"
                                       value="<?php echo e($setting->name); ?>">
                            </div>
                        </div>


                        <div class="form-group">
                            <label class="control-label col-md-2">Currency</label>
                            <div class="col-md-6">
                                <select class="bs-select form-control" data-show-subtext="true" name="currency">
                                    <option data-icon="fa-inr" value="fa-inr:INR"
                                            <?php if($setting->currency=='INR'): ?> selected <?php endif; ?>>INR
                                    </option>
                                    <option data-icon="fa-usd" value="fa-usd:USD"
                                            <?php if($setting->currency=='USD'): ?> selected <?php endif; ?>>USD
                                    </option>
                                    <option data-icon="fa-euro" value="fa-euro:EURO"
                                            <?php if($setting->currency=='EURO'): ?> selected <?php endif; ?> >EURO
                                    </option>
                                    <option data-icon="fa-gbp" value="fa-gbp:GBP"
                                            <?php if($setting->currency=='GBP'): ?> selected <?php endif; ?>>GBP
                                    </option>
                                    <option data-icon="fa-jpy" value="fa-jpy:JPY"
                                            <?php if($setting->currency=='JPY'): ?> selected <?php endif; ?> >JPY
                                    </option>
                                    <option data-icon="fa-yen" value="fa-yen:YEN"
                                            <?php if($setting->currency=='YEN'): ?> selected <?php endif; ?>>YEN
                                    </option>
                                    <option data-icon="fa-won" value="fa-won:WON"
                                            <?php if($setting->currency=='WON'): ?> selected <?php endif; ?>>WON
                                    </option>
                                    <option data-icon="fa-try" value="fa-try:TRY"
                                            <?php if($setting->currency=='TRY'): ?> selected <?php endif; ?>>TRY
                                    </option>
                                    <option data-icon="fa-rub" value="fa-yen:YEN"
                                            <?php if($setting->currency=='RUB'): ?> selected <?php endif; ?>>RUB
                                    </option>
                                    <option data-icon="fa-rmb" value="fa-rmb:RMB"
                                            <?php if($setting->currency=='RMB'): ?> selected <?php endif; ?>>RMB
                                    </option>
                                    <option data-icon="fa-krw" value="fa-krw:KRW"
                                            <?php if($setting->currency=='KRW'): ?> selected <?php endif; ?>>KRW
                                    </option>
                                    <option data-icon="fa-btc" value="fa-btc:BTC"
                                            <?php if($setting->currency=='BTC'): ?> selected <?php endif; ?>>BTC
                                    </option>
                                    <option data-icon="fa-xof" value="fa-xof:XOF"
                                            <?php if($setting->currency=='XOF'): ?> selected <?php endif; ?>>XOF
                                    </option>
                                    <option data-icon="fa-myr" value="fa-myr:MYR"
                                            <?php if($setting->currency=='MYR'): ?> selected <?php endif; ?>>MYR
                                    </option>
                                    <option data-icon="fa-pkr" value="fa-pkr:PKR"
                                            <?php if($setting->currency=='PKR'): ?> selected <?php endif; ?>>PKR
                                    </option>

                                </select>
                            </div>
                        </div>

                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" onclick="updateSetting(<?php echo e($setting->id); ?>)"
                                            class="btn green"><i class="fa fa-check"></i> Submit
                                    </button>

                                </div>
                            </div>
                        </div>
                    <?php echo Form::close(); ?>

                    <!------------------------- END FORM ----------------------->

                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->

            </div>
        </div>
        <!-- END PAGE CONTENT-->


    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('footerjs'); ?>

        <!-- BEGIN PAGE LEVEL PLUGINS -->
            <?php echo HTML::script("assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js"); ?>

            <?php echo HTML::script('assets/global/plugins/bootstrap-select/bootstrap-select.min.js'); ?>


            <?php echo HTML::script('assets/global/plugins/select2/select2.min.js'); ?>

            <?php echo HTML::script('assets/global/plugins/jquery-multi-select/js/jquery.multi-select.js'); ?>

            <?php echo HTML::script('assets/admin/pages/scripts/components-dropdowns.js'); ?>




            <script>
                jQuery(document).ready(function () {

                    ComponentsDropdowns.init();
                });

                function updateSetting(id) {

                    var url = "<?php echo e(route('admin.settings.update',':id')); ?>";
                    url = url.replace(':id', id);
                    $.easyAjax({
                        type: 'POST',
                        url: url,
                        container: '#edit_setting_form',
                        file: true
                    });
                }
            </script>
            <!-- END PAGE LEVEL PLUGINS -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.adminlayouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jemysunc/hrms.jemysun.co.ke/resources/views/admin/settings/edit.blade.php ENDPATH**/ ?>